program firebird_alias_create;

uses
  Forms,
  Windows, Classes, SysUtils;

{$R *.res}

var
  arq: TStringList;
  alias_file, path_banco, alias: String;
begin
  Application.Initialize;
  //Parmetros permitidos na aplicao
  //ParamStr(1) = pasta de instalao do servidor firebird
  //ParamStr(2) = nome do alias
  //ParamStr(3) = path do banco a ser registrado no arquivo aliases.conf
  
  //A aplicao deve receber 3 parmetros.
  if ParamCount <> 3 then
     Application.MessageBox(pchar(
       'A aplicao deve receber 3 parmetros: ' +
	     'pasta_firebird caminho_banco nome_alias'),
       'Erro', MB_ICONERROR)
  else
  begin
    {A varivel alias_file armazena o caminho e nome do 
	  arquivo aliases.conf do Firebird.}
    alias_file:= ParamStr(1);
    if alias_file[length(alias_file)] <> '\' then
       alias_file:= alias_file + '\';
    alias_file:= alias_file + 'aliases.conf';
	
	  //Nome do alias a ser criado no arquivo aliases.conf do Firebird.
    alias:= ParamStr(2);
   	//Caminho do banco de dados a ser registrado no aliases.conf
    path_banco:= ParamStr(3);
    if not FileExists(alias_file) then
    begin
      Application.MessageBox(
        pchar('O arquivo de aliases "' + alias_file +
        '" do servidor Firebird no existe.'),
        'Erro', MB_ICONERROR);
      exit;
    end;
    if not FileExists(path_banco) then
    begin
      Application.MessageBox(
        pchar('O arquivo do banco de dados "' + path_banco +
        '" no existe.'),
        'Erro', MB_ICONERROR);
      exit;
    end;

    arq:= TStringList.Create;
    try
	    //Abre o arquivo aliases.conf
      arq.LoadFromFile(alias_file);

      //O alias pode estar no formato alias=caminho ou alias = caminho
	    {Verifica se existe uma chave com o nome do alias
	    no arquivo aliases.conf}
      if arq.IndexOfName(alias) > -1 then
	       //Se o alias j existir ele  alterado.
	       arq.Values[alias]:= path_banco
	    else
      begin
	      {Como o alias pode estar no formato "alias = caminho" (com espao
		    um espao antes e depois do igual), verifica se existe uma chave
		     igual a "alias "}
         if arq.IndexOfName(alias + ' ') > -1 then
		        //Se o alias j existir ele  alterado.
            arq.Values[alias + ' ']:= path_banco
         //Se o alias no existir ele  adicionado.
         else arq.add(alias + '=' + path_banco);
      end;
	    //Salvar o arquivo aliases.conf alterado
      arq.SaveToFile(alias_file);
    finally
      arq.free;
    end;
  end;
  Application.Run;
end.
